/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.ui.editor.formatting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.ui.editor.PHPSourceViewerConfiguration;
import com.aptana.editor.php.internal.ui.editor.formatting.AbstractPHPAutoEditStrategy;
import com.aptana.editor.php.internal.ui.editor.formatting.BlockEndingSyntaxAutoEditStrategy;
import com.aptana.editor.php.internal.ui.editor.formatting.PhpDocAutoIndentStrategy;
import com.aptana.editor.php.internal.ui.editor.formatting.SwitchCaseAutoEditStrategy;
import com.aptana.parsing.lexer.Lexeme;
import java.util.Arrays;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;

public class PHPAutoIndentStrategy
extends AbstractPHPAutoEditStrategy {
    private AbstractPHPAutoEditStrategy multiLineCommentStrategy;
    private AbstractPHPAutoEditStrategy switchCaseAutoEditStrategy;
    private AbstractPHPAutoEditStrategy alternativeSyntaxAutoEditStrategy;

    public PHPAutoIndentStrategy(String contentType, PHPSourceViewerConfiguration configuration, ISourceViewer sourceViewer) {
        super(contentType, configuration, sourceViewer);
        this.switchCaseAutoEditStrategy = new SwitchCaseAutoEditStrategy(contentType, configuration, sourceViewer);
        this.alternativeSyntaxAutoEditStrategy = new BlockEndingSyntaxAutoEditStrategy(contentType, configuration, sourceViewer);
        this.multiLineCommentStrategy = new PhpDocAutoIndentStrategy(contentType, configuration, sourceViewer);
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isAutoIndentEnabled()) {
            return;
        }
        this.innerCustomizeDocumentCommand(document, command);
        this.lexemeProvider = null;
    }

    protected void innerCustomizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text == null || command.length > 0) {
            return;
        }
        if (command.text.equals("}")) {
            this.getLexemeProvider(document, command.offset, true);
            this.customizeCloseCurly(document, command, (Lexeme<PHPTokenType>)this.lexemeProvider.getFloorLexeme(command.offset));
        }
        try {
            ITypedRegion region = document.getPartition(command.offset);
            String regionType = region.getType();
            if ("__php_phpdoc_comment".equals(regionType) || "__php_multiline_comment".equals(regionType)) {
                this.multiLineCommentStrategy.customizeDocumentCommand(document, command);
                return;
            }
            if (TextUtilities.endsWith((String[])document.getLegalLineDelimiters(), (String)command.text) != -1) {
                int lexemeLine;
                this.getLexemeProvider(document, command.offset, true);
                Lexeme floorLexeme = this.lexemeProvider.getFloorLexeme(command.offset);
                if (floorLexeme == null || floorLexeme.getType() == null) {
                    return;
                }
                int commandLine = document.getLineOfOffset(command.offset);
                if ("WHITESPACE".equals(((PHPTokenType)floorLexeme.getType()).getType()) && floorLexeme.getStartingOffset() > region.getOffset() && commandLine - (lexemeLine = document.getLineOfOffset((floorLexeme = this.lexemeProvider.getFloorLexeme(floorLexeme.getStartingOffset() - 1)).getStartingOffset())) > 0) {
                    this.indentAfterNewLine(document, command);
                    return;
                }
                String lexemeText = floorLexeme.getText();
                if (lexemeText.equals(":") || lexemeText.equals(";") || lexemeText.equals(")")) {
                    String indent;
                    Lexeme<PHPTokenType> previousNonWhitespaceLexeme;
                    String indent2;
                    if (lexemeText.equals(":") && (indent2 = this.indentAfterOneLineBlock(floorLexeme.getStartingOffset(), document)) != null) {
                        command.text = String.valueOf(command.text) + indent2;
                        return;
                    }
                    Lexeme<PHPTokenType> firstLexemeInLine = this.getFirstLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, floorLexeme.getStartingOffset());
                    if (firstLexemeInLine == null) {
                        return;
                    }
                    if (lexemeText.equals(";") && (previousNonWhitespaceLexeme = this.getPreviousNonWhitespaceLexeme(firstLexemeInLine.getStartingOffset() - 1)) != null && (indent = this.indentAfterOneLineBlock(previousNonWhitespaceLexeme.getStartingOffset(), document)) != null) {
                        command.text = String.valueOf(command.text) + indent;
                        return;
                    }
                    if (lexemeText.equals(")")) {
                        this.indentAfterNewLine(document, command);
                        return;
                    }
                    this.indentAfterNewLine(document, command);
                    return;
                }
                if (lexemeText.equals("else") || lexemeText.equals("elseif")) {
                    this.indentAfterNewLine(document, command);
                    command.text = String.valueOf(command.text) + this.configuration.getIndent();
                } else if (lexemeText.equals("}")) {
                    if (command.offset == floorLexeme.getStartingOffset()) {
                        Lexeme<PHPTokenType> previousNonWhitespaceLexeme = this.getPreviousNonWhitespaceLexeme(floorLexeme.getStartingOffset() - 1);
                        if (previousNonWhitespaceLexeme != null && "{".equals(previousNonWhitespaceLexeme.getText())) {
                            this.indentAfterOpenBrace(document, command);
                        } else {
                            this.customizeCloseCurly(document, command, (Lexeme<PHPTokenType>)floorLexeme);
                        }
                    } else {
                        this.customizeCloseCurly(document, command, (Lexeme<PHPTokenType>)floorLexeme);
                    }
                } else if (!this.indentAfterOpenBrace(document, command)) {
                    command.text = String.valueOf(command.text) + this.copyIntentationFromPreviousLine(document, command);
                }
            } else {
                if (this.alternativeSyntaxAutoEditStrategy.isValidAutoInsertLocation(document, command)) {
                    this.alternativeSyntaxAutoEditStrategy.setLexemeProvider(this.getLexemeProvider(document, command.offset, true));
                    this.alternativeSyntaxAutoEditStrategy.customizeDocumentCommand(document, command);
                }
                if (this.switchCaseAutoEditStrategy.isValidAutoInsertLocation(document, command)) {
                    this.switchCaseAutoEditStrategy.setLexemeProvider(this.getLexemeProvider(document, command.offset, true));
                    this.switchCaseAutoEditStrategy.customizeDocumentCommand(document, command);
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error in the PHP auto-indent strategy", (Throwable)e);
            return;
        }
    }

    protected String indentAfterOneLineBlock(int offset, IDocument document) throws BadLocationException {
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        String indent = null;
        if (lineInfo.getOffset() > 0) {
            Lexeme<PHPTokenType> firstLexemeInLine = null;
            int count = 10;
            do {
                if (count-- == 0) {
                    IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"Stopped a possible infinite loop in the PHPAutoIndentStrategy", (String)"com.aptana.editor.php/debug");
                    break;
                }
                firstLexemeInLine = this.getFirstLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, lineInfo.getOffset());
                Lexeme<PHPTokenType> lastLexemeInLine = this.getLastLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, (lineInfo = document.getLineInformationOfOffset(firstLexemeInLine.getStartingOffset())).getOffset());
                if (lastLexemeInLine == null || firstLexemeInLine == null || !BLOCK_TYPES.contains(((PHPTokenType)firstLexemeInLine.getType()).getType()) && !BLOCK_TYPES.contains(((PHPTokenType)lastLexemeInLine.getType()).getType())) break;
                if ("{".equals(lastLexemeInLine.getText()) || ":".equals(lastLexemeInLine.getText())) {
                    if (indent == null) {
                        return String.valueOf(this.configuration.getIndent()) + this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset());
                    }
                    return indent;
                }
                if ("else".equals(lastLexemeInLine.getText())) {
                    return this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset());
                }
                indent = this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset());
            } while (firstLexemeInLine != null && lineInfo != null);
        }
        return indent;
    }

    protected boolean indentAfterOpenBrace(IDocument d, DocumentCommand command) {
        int offset = command.offset;
        boolean result = false;
        if (offset != -1 && d.getLength() != 0) {
            String currentLineIndent = this.copyIntentationFromPreviousLine(d, command);
            String newline = command.text;
            String indent = this.configuration.getIndent();
            try {
                if (offset > 0) {
                    char c;
                    while (Character.isWhitespace(c = d.getChar(offset - 1)) && --offset > 0) {
                    }
                    int offsetShift = command.offset - offset;
                    if (c == '{') {
                        String startIndent = String.valueOf(newline) + currentLineIndent + indent;
                        boolean hasClosing = false;
                        if (offset < d.getLength()) {
                            int charOffset = offset;
                            int charsToDelete = 0;
                            int docLen = d.getLength();
                            while (charOffset < docLen) {
                                char next = d.getChar(charOffset);
                                if (next == '}') {
                                    hasClosing = true;
                                    break;
                                }
                                if (next == '\n' || next == '\r' || !Character.isWhitespace(next)) break;
                                ++charsToDelete;
                                ++charOffset;
                            }
                            if (hasClosing) {
                                d.replace(offset, charsToDelete, "");
                            }
                        }
                        command.text = offset < d.getLength() && d.getChar(offset) == '}' ? String.valueOf(startIndent) + newline + currentLineIndent : startIndent;
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + startIndent.length() - offsetShift;
                        result = true;
                    }
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error in the PHP auto-indent strategy", (Throwable)e);
            }
        }
        if (result) {
            command.offset = offset;
        }
        return result;
    }

    private void customizeCloseCurly(IDocument document, DocumentCommand command, Lexeme<PHPTokenType> curlyLexeme) {
        try {
            if (!"}".equals(command.text)) {
                int curlyOpenOffset = this.getPervPairMatchOffset("{", curlyLexeme.getStartingOffset() - 1, document);
                Lexeme<PHPTokenType> firstLexemeInLine = this.getFirstLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, curlyOpenOffset);
                if (firstLexemeInLine != null) {
                    command.text = String.valueOf(command.text) + this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset());
                }
            } else {
                Lexeme<PHPTokenType> nonWhitespaceLexeme = this.getFirstLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, command.offset);
                if (nonWhitespaceLexeme == null) {
                    IRegion lineRegion = document.getLineInformationOfOffset(command.offset);
                    if (command.offset > lineRegion.getOffset()) {
                        int length = command.offset - lineRegion.getOffset();
                        command.offset -= length;
                        document.replace(lineRegion.getOffset(), length, "");
                        int curlyOpenOffset = this.getPervPairMatchOffset("{", command.offset - 1, document);
                        if (curlyOpenOffset < 0) {
                            command.text = String.valueOf(this.copyIntentationFromPreviousLine(document, command)) + command.text;
                        } else {
                            Lexeme<PHPTokenType> firstLexemeInLine = this.getFirstLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, curlyOpenOffset);
                            if (firstLexemeInLine != null) {
                                command.text = String.valueOf(this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset())) + command.text;
                            }
                        }
                    } else {
                        int curlyOpenOffset = this.getPervPairMatchOffset("{", command.offset - 1, document);
                        if (curlyOpenOffset < 0) {
                            String indentForCurrentLine = this.copyIntentationFromPreviousLine(document, command);
                            command.text = String.valueOf(indentForCurrentLine) + command.text;
                        } else {
                            Lexeme<PHPTokenType> firstLexemeInLine = this.getFirstLexemeInLine(document, (ILexemeProvider<PHPTokenType>)this.lexemeProvider, curlyOpenOffset);
                            if (firstLexemeInLine != null) {
                                command.text = String.valueOf(this.getIndentationAtOffset(document, firstLexemeInLine.getStartingOffset())) + command.text;
                            }
                        }
                    }
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error in the PHP auto-indent strategy", (Throwable)e);
        }
    }

    protected String copyIntentationFromPreviousLine(IDocument document, DocumentCommand command) {
        if (command.offset == -1 || document.getLength() == 0) {
            return "";
        }
        try {
            int p = command.offset;
            if (p > 0) {
                --p;
            }
            IRegion info = document.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(document, start, command.offset);
            StringBuffer buf = new StringBuffer();
            if (end > start) {
                buf.append(document.get(start, end - start));
            }
            return buf.toString();
        }
        catch (BadLocationException excp) {
            IdeLog.logWarning((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP Auto Edit Strategy - Bad location while computing an indentation (copyIntentationFromPreviousLine)", (Throwable)excp, (String)"com.aptana.editor.php/debug");
            return "";
        }
    }

    public boolean canOverwriteBracket(char bracket, int offset, IDocument document, ILexemeProvider<PHPTokenType> ll) {
        if (offset < document.getLength()) {
            char[] autoOverwriteChars = this.getAutoOverwriteCharacters();
            Arrays.sort(autoOverwriteChars);
            if (Arrays.binarySearch(autoOverwriteChars, bracket) < 0) {
                return false;
            }
            try {
                char sibling = document.getChar(offset);
                return sibling == bracket;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }
}

